############################################################################

#

#   SMTP- -   ,  

#     ,    EML- Outlook.

#

############################################################################

# 

# Copyright (c) 2004 Alexander Bougakov, http://www.bougakov.com/go/cityblog/

#        Creative Commons License:

# http://creativecommons.org/licenses/by-nc-sa/1.0/

#

#     Net::SMTP::Server, Net::SMTP::Server::Client 

# Net::SMTP::Server::Client2  Habeeb J. Dihu  David Nicole,

# .

#

############################################################################


unshift @INC, './'; #  Perl   

                    #   ,     /lib

use Carp;

use smtpserver;

use smtpclient;


#   INI-:

if(-f "smtp-emulator.ini"){ } else {

	open (INI, ">>smtp-emulator.ini");

	print INI "; INI-file for SMTP Emulator\n; Copyright (c) Alexandre Bougakov\n; http://www.bougakov.com/go/cityblog/\n\n[SMTP]\n\n; Host and port to bind to:\n; (defaults are 'localhost' and '25')\nhost  = localhost\nport  = 25\n\n; Max message size (in bytes):\nlimit = 1000000\n\n; Log file:\nlog   = SMTPlog.txt\n";

	close(INI);

};


use Config::IniFiles;

my $cfg = new Config::IniFiles( -file => "smtp-emulator.ini", -nocase => 1 );


#     ( )    

# (   552  RfC 821):

my $limit = $cfg->val( 'SMTP', 'limit', 1000000 );


#    (, ):

my $host  = $cfg->val( 'SMTP', 'host',  'localhost' );

my $port  = $cfg->val( 'SMTP', 'port',   25 );


# :

my $log = $cfg->val( 'SMTP', 'log',     'SMTP_log.txt');


#      $log.eml -    

#   .       Outlook Express

# -    ,      (  

#       ""   

#     POP3,   ?) 


#     " ,  ,  ,

#     " -  ,   

# ,         ,   

#  .


#  ,    , .     

#    ,      

# (    )


##  : #############################################################


# Welcome-screen:


system(cls);


print "___________________________________________________________________\n\n";

print " SMTP server emulator is now working on \"" . $host .":" . $port ."\"\n\n";

print " Conversations with clients will be logged to \"" . $log ."\" file\n";

print " (overwrites older one, if present). Outlook-readable copy will be\n"; 

print " saved to \"" . $log .".eml\" (If several messages will be sent in\n";

print " the batch, only the last one will be there!) Server's responses\n";

print " will be echoed to this window.\n\n";

print " Press Ctrl+C to close this window and stop the emulator.\n";

print "___________________________________________________________________\n\n";


#   :

unlink $log;

unlink $log . ".eml";


#       :

my $server = new smtpserver($host => $port) || croak("Unable to launch or bind server: $!\n");

while($conn = $server->accept()) {

    fork and last;

    $conn->close;

};


#  :

my $count = '';

my $client = new smtpclient($conn, $log) || croak("Unable to start interface: $!\n");

$client->greet;

while($client->get_message){

    if (length($client->{MSG}) > $limit){

        $client->too_long;

    } else {

        $count++;

        $client->okay("Message accepted");

        $client->closelog;

    }

}