package smtpclient;

use strict;
use vars qw($LOGF);
use Carp;
use IO::Socket;

#   :
my $LOGF = "SMTP_log.txt";

my %_cmds = (
    DATA => \&_data,
    EXPN => \&_noway,
    HELO => \&_hello,
    HELP => \&_help,
    MAIL => \&_mail,
    NOOP => \&_noop,
    QUIT => \&_quit,
    RCPT => \&_receipt,
    RSET => \&_reset,
    VRFY => \&_noway
);

sub _reset0 {
    my $self = shift;
    $self->{FROM} = undef;
    $self->{TO} = [];
    $self->{MSG} = undef;
    $self->{faults} = 0;
}
 
sub _reset {
    my $self = shift;
    $self->_reset0;
    $self->_put("250 Mail transaction aborted");
}

sub new {
    my($this, $sock, $log) = @_;
    my $class = ref($this) || $this;
    my $self = {};
    $LOGF = $log;
    bless($self, $class);
    $self->_reset0;
    $self->{SOCK} = $sock;
    croak("No client connection specified.") unless defined($self->{SOCK});
    open(LOG, ">>$LOGF");
    print LOG "###  SMTP- ### " . scalar(localtime) . " ###\n\n";
    close(LOG);
    unlink $log . ".eml";
    return $self;
}

sub greet {
    $_[0]->_put("220 SMTP Emulator ready.");
}

sub basta{
    my $self = shift;
    $self -> _put("421 closing transmission channel");
    $self->{SOCK}->close;
    1;
}

sub get_message {
    my $self = shift;
    my($cmd, @args);
    my $sock = $self->{SOCK};
    $self->_reset0;
    while(<$sock>) {
        chomp;
        open(LOG, ">>$LOGF");
        print LOG $_ , "";
        close(LOG);
        $$self{faults} > 15 and $self->basta and last;
        s/^\s+//;
        s/\s+$//;
        unless(length $_){
            ++$$self{faults};
            $self->greet;
            next;
        };
        ($cmd, @args) = split(/\s+/);
        $cmd =~ tr/a-z/A-Z/;
        if(!defined($_cmds{$cmd})) {
            sleep ++$$self{faults};
            $self->_put("500 Server doesn't know how to $cmd");
            next;
        };
        &{$_cmds{$cmd}}($self, \@args) or
            return(defined($self->{MSG}));
        }
        return undef;
}

sub find_addresses {
    return map { /([^<|;]+\@[^>|;&,\s]+)/ ? $1 : () } @_;
};

sub okay {
    my $self = shift;
    $self -> _put("250 OK @_");
}

sub fail {
    my $self = shift;
    $self -> _put("554 @_");
}

sub too_long {
    $_[0] -> _put("552 Requested mail action aborted: exceeded storage allocation");
};

sub _mail {
    my $self = $_[0];
    my @who = find_addresses(@{$_[1]});
    my $who = shift @who;
    if ($who){
        $self->{FROM} = $who;
        return $self->okay("Envelope sender set to <$who> ")
    }else{
        $self->{faults}++;
        return $self-> _put("501 could not find name\@postoffice in <@{$_[1]}>")
    };
}

sub rcpt_syntax{
    $_[0] -> _put("553 no user\@host addresses found in <@{$_[1]}>");
}

sub _receipt {
    my $self = $_[0];
    my @recipients = find_addresses(@{$_[1]});
    @recipients or return $self->rcpt_syntax($_[1]);
    push @{ $self->{TO} }, @recipients;
    $self->okay("sending to @{$self->{TO}}");
}

sub _put {
    print {shift->{SOCK}} @_, "\r\n";
    print "### ", @_, "\n";
    open(LOG, ">>$LOGF");
    print LOG "", @_ , "\n";
    close(LOG);
}

sub _data {
    my $self = shift;
    my @msg;
    if(!$self->{FROM}) {
        $self-> _put("503 start with 'mail from: ...'");
        $self->{faults}++;
        return 1;
    }
    if(!@{$self->{TO}}) {
        $self->_put("503 specify recipients with 'RCPT TO: ...'");
        $self->{faults}++;
        return 1;
    }
    $self->_put("354 Start mail input, end with CRLF-dot-CRLF");
    my $sock    = $self->{SOCK};
    while(<$sock>) {
        chomp;
        s/\x0D/\x0A/sg;
        s/\x0D\x0D/\x0D/sg;
        if(/^\.\r*\n*$/) {
            $self->{MSG} = join ('', @msg);
            return 0;
        }
        #   RFC 821.
        s/^\.\./\./;
        push @msg, $_;
        open(LOG, ">>$LOGF");
        print LOG $_;
        close(LOG);
        open(EML, ">>$LOGF.eml");
        print EML $_;
        close(EML);
    }
    return 0;
}

sub closelog {
    open(LOG, ">>$LOGF");
    print LOG "\n\n###   ###\n\n\n\n";
    close(LOG);
}

sub _noway {
    shift->_put("252 Nice try.");
}

sub _noop {
    shift->_put("250 OK, server will wait.");
}

sub _help {
    my $self = shift;
    my $i = 0;
    my $str = "214-Commands\r\n";
    my $total = keys(%_cmds);
    foreach(sort(keys(%_cmds))) {
        if(!($i++ % 5)) {
            if(($total - $i) < 5) {
                $str .= "\r\n214 ";
            } else {
                $str .= "\r\n214-";
            }
        } else {
            $str .= ' ';
        }
    $str .= $_;
    }
    $self->_put($str);
}

sub _quit {
    my $self = shift;
    $self->_put("221 Closing communication");
    $self->{SOCK}->close;
    return 0;
}

sub _hello {
    shift->okay( "Welcome" );
}

1;
