package smtpserver;

use strict;
use vars qw(@ISA @EXPORT);

require Exporter;
require AutoLoader;

use Carp;
use IO::Socket;
use Sys::Hostname;

@ISA	= qw(Exporter AutoLoader);
@EXPORT	= qw();

sub new {
    my $this	  = shift;
    my $class	  = ref($this) || $this;
    my $self	  = {};
    $self->{HOST} = shift;
    $self->{PORT} = shift;
    bless($self, $class);
    $self->{HOST} = hostname	unless defined($self->{HOST});
    $self->{PORT} = 25			unless defined($self->{PORT});
    $self->{SOCK} = IO::Socket::INET->new(
    	Proto	  => 'tcp',
    	LocalAddr => $self->{HOST},
    	LocalPort => $self->{PORT},
    	Listen    => SOMAXCONN,
    	Reuse     => 1
    );
    return defined($self->{SOCK}) ? $self : undef;
}

sub accept {
    my $self = shift;
    my $client;
    if($client = $self->{SOCK}->accept()) {
	    $self->{SOCK}->autoflush(1);
	    return $client;
    }
    return undef;
}

sub DESTROY {
    shift->{SOCK}->close;
}

1;