@auto[]
#source/client charsets
$request:charset[utf-8]
$response:charset[utf-8]

$response:content-type[
	$.value[text/html]
	$.charset[$response:charset]
]

#$SQL.connect-string[mysql://user:pass@host/db?charset=utf8]
#$SQL.connect-string[sqlite://db]
#$SQL.connect-string[pgsql://user:pass@host/db]
#$SQL.connect-string[odbc://DSN=datasource^;UID=user^;PWD=password]


@conf[filespec]
$confdir[^file:dirname[$filespec]]
$charsetsdir[$confdir/charsets]
$sqldriversdir[$confdir/lib]

$CHARSETS[
#	$.cp866[$charsetsdir/cp866.cfg]
#	$.koi8-r[$charsetsdir/koi8-r.cfg]
#	$.koi8-u[$charsetsdir/koi8-u.cfg]
#	$.windows-1250[$charsetsdir/windows-1250.cfg]
#	$.windows-1251[$charsetsdir/windows-1251.cfg]
#	$.windows-1254[$charsetsdir/windows-1254.cfg]
#	$.windows-1257[$charsetsdir/windows-1257.cfg]
#	$.x-mac-cyrillic[$charsetsdir/x-mac-cyrillic.cfg]
]

#change your client libraries paths to those on your system
$SQL[
	$.drivers[^table::create{protocol	driver	client
mysql	$sqldriversdir/libparser3mysql.so	libmariadb.so,libmysqlclient.so
#sqlite	$sqldriversdir/libparser3sqlite.so	libsqlite3.so
#pgsql	$sqldriversdir/libparser3pgsql.so	libpq.so
#oracle	$sqldriversdir/libparser3oracle.so	libclntsh.so
}]
]

#for ^file::load[name;user-name] mime-type autodetection
$MIME-TYPES[^table::create{ext	mime-type
7z	application/x-7z-compressed
avi	video/x-msvideo
bmp	image/bmp
css	text/css
cvs	text/csv
doc	application/msword
docx	application/vnd.openxmlformats-officedocument.wordprocessingml.document
dtd	application/xml-dtd
gif	image/gif
gz	application/x-gzip
htm	text/html
html	text/html
ico	image/x-icon
jpeg	image/jpeg
jpg	image/jpeg
js	application/javascript
json	application/json
log	text/plain
mov	video/quicktime
mp3	audio/mpeg
mp4	video/mp4
mpg	video/mpeg
mpeg	video/mpeg
mts	application/metastream
otf	font/otf
pdf	application/pdf
png	image/png
ppt	application/powerpoint
rar	application/vnd.rar
rdf	application/rdf+xml
rss	application/rss+xml
rtf	application/rtf
svg	image/svg+xml
tar	application/x-tar
tgz	application/x-gzip
tif	image/tiff
tiff	image/tiff
ttf	font/ttf
txt	text/plain
wav	audio/x-wav
xls	application/vnd.ms-excel
xlsx	application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
xml	text/xml
xsl	text/xml
webm	video/webm
webp	image/webp
woff	font/woff
woff2	font/woff2
zip	application/zip
}]

$LIMITS[
	$.post_max_size(64*0x400*0x400)
#	$.max_file_size(512*0x400*0x400)
#	$.max_loop(100000)
#	$.max_array_size(1000000)
#	$.max_recursion(1000)
]

#$HTTPD[
#	$.mode[threaded]
#]

#$MAIL[
#	$.SMTP[localhost]
#]


@fatal_error[title;subtitle;body]
$response:status(500)
$response:content-type[
	$.value[text/html]
	$.charset[$response:charset]
]
<html>
<head><title>$title</title></head>
<body>
<h1>^if(def $subtitle){$subtitle;$title}</h1>
$body
#for [x] MSIE friendly
^for[i](0;512/8){<!-- -->}
</body>
</html>


@unhandled_exception_debug[exception;stack]
^fatal_error[Unhandled Exception^if(def $exception.type){ ($exception.type)};$exception.source;
<pre>^untaint[html]{$exception.comment}</pre>
^if(def $exception.file){
	^untaint[html]{<tt>$exception.file^(${exception.lineno}:$exception.colno^)</tt>}
}
^if($stack){
	<hr/>
	<table>
	^stack.menu{
		<tr><td>$stack.name</td><td><tt>$stack.file^(${stack.lineno}:$stack.colno^)</tt></td></tr>
	}
	</table>
}
]


@unhandled_exception_release[exception;stack]
^fatal_error[Unhandled Exception;;

<p>The server encountered an unhandled exception and was unable to complete your request.</p>
<p>Please contact the server administrator, $env:SERVER_ADMIN and inform them of the time the error occurred, and anything you might have done that may have caused the error.</p>
<p>More information about this error may be available in the Parser error log or in debug version of unhandled_exception.</p>

]


@is_developer[]
#change mask to your ip address
$result(def $env:REMOTE_ADDR && ^env:REMOTE_ADDR.match[^^127\.0\.0\.1^$])


@unhandled_exception[exception;stack]
#developer? use debug version to see problem details
^if(^is_developer[]){
	^unhandled_exception_debug[$exception;$stack]
}{
	^if($exception.type eq "file.missing"){
#		$response:location[/404/]
		^httpd:404[]
	}{
		^unhandled_exception_release[$exception;$stack]
	}
}


@CLASS
httpd

@OPTIONS
partial

@auto[]
^if(-f "/httpd.p"){
	^use[/httpd.p]
}

@include[filename]
^use[$filename; $.main(true) ]
^MAIN:main[]

@index[dir][list]
^fatal_error[Index of $dir;Index of $dir;
	$list[^file:list[$dir]]
	^list.sort{^if($list.dir)[0;1] $list.name}
	^list.menu{
		<a href="$list.name^if($list.dir){/}">^if($list.dir){/}$list.name</a><br/>
	}
]
$response:status(200)

# option can be method, URL or text/code
@option[option]
$result[^if($option is junction){^option[]}(^option.match[$cfg.parser]){^include[$option]}{$option}]

@file[filename]
$result[^if(^filename.match[$cfg.parser]){^include[$filename]}{$response:body[ $.file[$filename] $.name[] ]}]

@log[filename;detail][now;line]
$now[^date::now[]]
$line[$env:REMOTE_ADDR [^now.sql-string[]] "$request:method $request:uri"$detail^#0A]
^line.save[append;$filename]

@404[]
$response:status[404]
The requested URL was not found on this server.

@config[result]

@preprocess[return]


@main[result][basic]

#$request:document-root[/website/folder]

$cfg[^config[
	$.parser[\.(html)^$]
	$.index[index.html]
#	$.autoindex(true)
	$.404[$404]
#	$.404[/404.html]
#	$.fix-trailing-slash(true)
#	$.auth[ $.url[^^/\.?admin/] $.login[admin] $.password[change me] $.realm[site administration] ]
	$.deny[(/\.ht[^^/]+|\.p|\.cfg)^$]
	$.403[Permission denied]
	$.memory(64000)
#	$.log[/access.log]
]]

$response:server[Parser$env:PARSER_VERSION]
$response:date[^date::now[]]
$response:connection[close]
$uri[$request:path]

^if(def $cfg.log){
	^log[$cfg.log]
}
^if(def $cfg.memory && $status:memory.ever_allocated_since_compact > $cfg.memory){
	^memory:compact[]
}

^if(def $cfg.auth.url && ^uri.match[$cfg.auth.url]){
	$basic[$cfg.auth.login:$cfg.auth.password]
	^if($env:HTTP_AUTHORIZATION ne "Basic ^basic.base64[]"){
		$response:WWW-Authenticate[Basic realm="$cfg.auth.realm"]
		$response:status[401]
		^return[Authorization Required]
	}
	$env:REMOTE_USER[$cfg.auth.login]
}

^if(def $cfg.deny && ^uri.match[$cfg.deny]){
	$response:status[403]
	^return[^option[$cfg.403]]
}(def $cfg.[fix-trailing-slash] && ^uri.match[^^[^^.]+[^^/.]^$]){
	^return[$response:location[$uri/^if(def $request:query){?^taint[as-is;$request:query]}]]
}

^preprocess{^return[]}

^if(def $cfg.index && -f "$uri/$cfg.index"){
	$result[^file[$uri/$cfg.index]]
}($cfg.autoindex && -d "$uri"){
	$result[^index[$uri]]
}(-f $uri){
	$result[^file[$uri]]
}{
	$result[^option[$cfg.404]]
}
